<?php
defined('ABSPATH') or die('No script kiddies please!');

add_action( 'widgets_init', 'roman_reg_jalasat' );
function roman_reg_jalasat() {

	register_widget( 'yahosein_widget_jalasat' );

}

class yahosein_widget_jalasat extends WP_Widget {
	private static $widget_id;

	/*  Constructor
	/* ------------------------------------ */
	function __construct() {
		parent::__construct(false, __('A_wd7:: جلسات هفتگی', 'yahosein'), array('description' => __('::wd7::نمایش جلسات هفتگی', 'yahosein'), 'classname' => 'yahosein_widget_jalasat  barname_haftegi'));
	}

	/**
	 * Front-end display of widget.
	 *
	 * @see WP_Widget::widget()
	 *
	 * @param array $args Widget arguments.
	 * @param array $instance Saved values from database.
	 */
	public function widget($args, $instance) {
		self::$widget_id = $args['widget_id'];
		echo $args['before_widget'];
		echo $args['before_title'] . apply_filters('widget_title', $instance['title']) . $args['after_title'] ;

		$this->tabsContent($instance);
		echo $args['after_widget'];
	}

	public function tabsContent($args) {

		$title = $args['title'];
		$img = $args['img'];
		$days = array
		(
			0=>'شنبه',
			1=>'یک شنبه',
			2=>'دو شنبه',
			3=>'سه شنبه',
			4=>'چهار شنبه',
			5=>'پنج شنبه',
			6=>'جمعه',
		);
		?>
		<ul class="weekly_schedule">
			<?php 
			foreach ($days as $key => $value) {
				$day = $args['day'.$key];
				if(!empty($day))
				{
					?>
					<li>
						<aside class="zaman"><?=$value?> ها</aside>
						<aside class="job"> <?=$day?></aside>
				</li>
					<?php
				}
			}
			 ?>

		</ul>

		<?php

	}

	/**
	 * Back-end widget form.
	 *
	 * @see WP_Widget::form()
	 *
	 * @param array $instance Previously saved values from database.
	 */
	public function form($instance) {
		$title = !empty($instance['title']) ? $instance['title'] : __('جلسات هفتگی', 'yahosein');
		$img = !empty($instance['img']) ? $instance['img'] : get_template_directory_uri().'/layouts/img/tablighat1.png';
		$link = !empty($instance['link']) ? $instance['link'] : get_bloginfo('url' );
		?>
		<style>
			.yahosein-cat-slider{ padding:3px; border:1px solid #bbb; border-radius:3px; margin:5px; }
			.yahosein-cat-slider select {  max-width: 100%; }
		</style>
		<p>
			<label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('عنوان:');?></label>
			<input class="widefat" id="<?php echo $this->get_field_id('title'); ?>"
			name="<?php echo $this->get_field_name('title'); ?>" type="text"
			value="<?php echo esc_attr($title); ?>">
		</p>
		<hr>
		<hr>
		<?php 
			$days = array
			(
				0=>'شنبه',
				1=>'یک شنبه',
				2=>'دو شنبه',
				3=>'سه شنبه',
				4=>'چهار شنبه',
				5=>'پنج شنبه',
				6=>'جمعه',
			);
			foreach ($days as $key => $value) {
				$day = !empty($instance['day'.$key]) ? $instance['day'.$key] : '';
				?>
				<p>
					<label for="<?php echo $this->get_field_id('day'.$key); ?>"><?php echo $value.' ها';?></label>
					<input class="widefat" id="<?php echo $this->get_field_id('day'.$key); ?>"
					name="<?php echo $this->get_field_name('day'.$key); ?>" type="text"
					value="<?php echo esc_attr($day); ?>">
				</p>
				<?php
			}
		 ?>


		<?php

	}

	/**
	 * Sanitize widget form values as they are saved.
	 *
	 * @see WP_Widget::update()
	 *
	 * @param array $new_instance Values just sent to be saved.
	 * @param array $old_instance Previously saved values from database.
	 *
	 * @return array Updated safe values to be saved.
	 */
	public function update($new_instance, $old_instance) {
		$instance = array();
		$instance['title'] = (!empty($new_instance['title'])) ? strip_tags($new_instance['title']) : 'جلسات هفتگی';
		$instance['img'] = (!empty($new_instance['img'])) ? strip_tags($new_instance['img']) : get_template_directory_uri().'/layouts/img/tablighat1.png';
		$days = array
		(
			0=>'شنبه',
			1=>'یک شنبه',
			2=>'دو شنبه',
			3=>'سه شنبه',
			4=>'چهار شنبه',
			5=>'پنج شنبه',
			6=>'جمعه',
		);
		foreach ($days as $key => $value) {
					$instance['day'.$key] = (!empty($new_instance['day'.$key])) ? strip_tags($new_instance['day'.$key]) : '';

		}

		return $instance;
	}


}
