<?php
if (!defined('ABSPATH')) {
    return;
}

/**
 * Calls the class on the post edit screen.
 */

if (is_admin()) {
    add_action('load-post.php', 'call_yahosein_metabox_cls');
    add_action('load-post-new.php', 'call_yahosein_metabox_cls');
}
function call_yahosein_metabox_cls()
{
    new yahosein_metabox_cls();
}

/**
 * The Class.
 */
class yahosein_metabox_cls
{
    /**
     * hold fields array
     * @var array
     */
    public $fields;
    /**
     * fields prefix
     * @var string
     */
    public $prefix;

    /**
     * Hook into the appropriate actions when the class is constructed.
     */
    public function __construct()
    {
        $this->prefix = 'yahosein';
        add_action('add_meta_boxes', array($this, 'add_meta_box'), 0);
        add_action('save_post', array($this, 'save'));
    }

    /**
     * Adds the meta box container.
     */
    public function add_meta_box($post_type)
    {
        $post_types = array('download'); //limit meta box to certain post types
        if (in_array($post_type, $post_types)) {
            //جزئیات پیامها
            add_meta_box(
                'yahosein_metabox_cls_fields'
                , __('<span class="dashicons dashicons-welcome-widgets-menus"></span> باکس خصوصیات', 'yahosein')
                , array($this, 'render_meta_box_content')
                , $post_type
                , 'advanced'
                , 'high'
            );
        }
    }

    /**
     * Save the meta when the post is saved.
     *
     * @param int $post_id The ID of the post being saved.
     */
    public function save($post_id)
    {

        if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) {
            return $post_id;
        }

        if (!current_user_can('manage_options')) {
            return $post_id;
        }

         //insert
         if(isset($_POST['yahosein_options'])){

            update_post_meta( $post_id, '_yahosein_options', $_POST['yahosein_options'] );
          }


    }

    /**
     * Render Meta Box content.
     *
     * @param WP_Post $post The post object.
     */
    public function render_meta_box_content($post)
    {
        $post_id = $post->ID;
        ?>
        <style type="text/css">
            .yahosein_fields .m_fields {
              border: 1px solid #d2d2d2;
              box-shadow: 1px 2px 3px 1px #eee;
              margin: 10px auto;
              padding: 10px;
              position: relative;
              width: 95%;
              cursor: all-scroll;
              background: #f9f9f9;
            }
            .yahosein_fields .m_fields > p {
              display: block;
            }
            .yahosein_fields > label {
                  display: block;
                    border-right: 1px solid #eee;
                 padding-right: 5px;
            }
            .yahosein_fields strong {
              min-width: 110px;
              display: block;
            }
            .yahosein_fields input {
              font-size: 10pt;
              height: 25px;
            }
            .yahosein_fields .t_clear{display: block;height: 1px;width: 100%;clear: both;}
            #footer-left , #footer-upgrade {  display: none;  }

        </style>
        <div class="yahosein_fields">
            <button class="button button-primary">اعمال تغییرات</button>
            <div class="t_clear"></div>
            <?php
            $yahosein_options = get_post_meta( $post_id, '_yahosein_options', true );
            ?>
            <div class="m_fields">
                <p><label><strong>نسخه</strong></label><input name="yahosein_options[ver]" type="text"  value="<?php echo @$yahosein_options['ver']; ?>"></p>
                <p><label><strong>لینک راهنما</strong></label><input name="yahosein_options[link_help]" type="text"  value="<?php echo @$yahosein_options['link_help']; ?>"></p>
                <p><label><strong>لینک پیش نمایش</strong></label><input name="yahosein_options[link_demo]" type="text"  value="<?php echo @$yahosein_options['link_demo']; ?>"></p>
                <hr>

            </div>
		</div>
        <?php


    }

}
