<?php
/**
 * Template part for displaying results in search pages
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package yahosein
 */

?>

<article id="post-<?php the_ID(); ?>" <?php post_class(array('col-md-4 col-sm-6 col-xs-12 blog_news')); ?>>
      <div class="category_module_item">
          <div class="product_hover">
            <a href="<?php the_permalink(); ?>" title="<?php echo esc_attr(get_the_title()); ?>">
            <?php ob_start(); ?>
            <?php 
            $img_size = 'roman-small';
            if(is_singular())
            {
              $img_size = 'full';
            }
            the_post_thumbnail($img_size ,array('class'=>(($roman_current_class =='post_odd')?'pull-left':'pull-right').' img_book_roman img-responsive wp-post-image'));
            ?>
           <?php
           $roman_pic_wrp = ob_get_clean(); 
           $roman_pic_wrp = trim($roman_pic_wrp);
           if(empty($roman_pic_wrp) && isset($yahosein['opt-posts-default-pic']['url']))
           {
              $roman_pic_wrp = '<img src="'.$yahosein['opt-posts-default-pic']['url'].'" class="img_responsive img_book_roman '.(($roman_current_class =='post_odd')?'pull-left':'pull-right').' img-responsive wp-post-image" alt="" width="250" height="300">';
           }
           ?> 
           <?php echo $roman_pic_wrp; ?>
              <div class="text_view">
                  <?php 
                  $icon_class = 'fa-film';
                  $posts_format = get_post_format( get_the_ID() );
                  switch ($posts_format) {
                    case 'video':{ $icon_class='fa-video-camera'; } break;
                    case 'audio':{ $icon_class='fa-music'; } break;
                    case 'image':{ $icon_class='fa-image'; } break;
                    
                  }
                  ?>
                  <i class="fa  <?=$icon_class?>"></i>
              </div>
            </a>
          </div>
          <div class="text_news_box">
              <h4>
        <a class="mod_articles_category_title" href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
      </h4>
              <div class="mod_articles_desc">
                  <p class="mod_articles_category_introtext"><?php the_title(); ?></p>
                  <div class="sub_footer">
                      <ol class="post_info">
                          <li class="date  pull-right">
                          	<?php 
															$time_string = '<time class="entry-date published updated" datetime="%1$s">%2$s</time>';
															// if ( get_the_time( 'U' ) !== get_the_modified_time( 'U' ) ) {
															// 	$time_string = '<time class="entry-date published" datetime="%1$s">%2$s</time> <small>(آخرین بروزرسانی : <time class="updated" datetime="%3$s">%4$s</time>)</small>';
															// }

															$time_string = sprintf( $time_string,
																esc_attr( get_the_date( 'c' ) ),
																esc_html( get_the_date() ),
																esc_attr( get_the_modified_date( 'c' ) ),
																esc_html( get_the_modified_date() )
															);
                          	 echo $time_string;
                          	 ?>

                          </li>
                          <li class="seeing"><span class="fa fa-eye"></span><span class="social_counts"><?php echo roman_getPostViews(get_the_ID()); ?></span></li>
                          <?php 
                          if(function_exists('get_simple_likes_button'))
                          {
                            echo get_simple_likes_button(get_the_ID()); 
                          }
                           ?>
                          <!-- <li class="share pull-left"><a href="#" data-toggle="tooltip" title="به اشتراک بگذارید." data-placement="right"> <span class="fa fa-share-alt"></span> </a></li> -->
                      </ol>
                  </div>
              </div>
          </div>
      </div>
</article><!-- #post-## -->



