<?php
/**
 * Template part for displaying a message that posts cannot be found
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package yahosein
 */

?>

<section class="no-results not-found container">
	<header class="page-header">
		<h1 class="page-title"><?php esc_html_e( 'مطلبی متناسب با کلمه جستجوی شما یافت نشد', 'yahosein' ); ?></h1>
	</header><!-- .page-header -->

	<div class="page-content">
		<?php
		if ( is_home() && current_user_can( 'publish_posts' ) ) : ?>

			<p><?php printf( wp_kses( __( 'آماده انتشار اولین مطلب خود در سایت هستید ؟ <a href="%1$s">پس شروع کنید</a>.', 'yahosein' ), array( 'a' => array( 'href' => array() ) ) ), esc_url( admin_url( 'post-new.php' ) ) ); ?></p>

		<?php elseif ( is_search() ) : ?>

			<p><?php esc_html_e( 'شاید بهتر باشد با کلمه ی دیگری جستجوی خود را امتحان کنید ، از کادر زیر کمک بگیرید', 'yahosein' ); ?></p>
			<?php
				get_search_form();

		else : ?>

			<p><?php esc_html_e( 'گویا چیزی مطابق با جستجوی شما یافت شند ، شاید استفاده از فرم جستجو کمک کند', 'yahosein' ); ?></p>
			<?php
				get_search_form();

		endif; ?>
	</div><!-- .page-content -->
</section><!-- .no-results -->
