<?php
/**
 * yahosein functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package yahosein
 */

if ( ! function_exists( 'yahosein_setup' ) ) :
/**
 * Sets up theme defaults and registers support for various WordPress features.
 *
 * Note that this function is hooked into the after_setup_theme hook, which
 * runs before the init hook. The init hook is too late for some features, such
 * as indicating support for post thumbnails.
 */
function yahosein_setup() {
	/*
	 * Make theme available for translation.
	 * Translations can be filed in the /languages/ directory.
	 * If you're building a theme based on yahosein, use a find and replace
	 * to change 'yahosein' to the name of your theme in all the template files.
	 */
	load_theme_textdomain( 'yahosein', get_template_directory() . '/languages' );

	// Add default posts and comments RSS feed links to head.
	add_theme_support( 'automatic-feed-links' );
	add_theme_support( 'post-formats', array( 'audio', 'video' ) );

	/*
	 * Let WordPress manage the document title.
	 * By adding theme support, we declare that this theme does not use a
	 * hard-coded <title> tag in the document head, and expect WordPress to
	 * provide it for us.
	 */
	add_theme_support( 'title-tag' );

	/*
	 * Enable support for Post Thumbnails on posts and pages.
	 *
	 * @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
	 */
	add_theme_support( 'post-thumbnails' );

	// This theme uses wp_nav_menu() in one location.
	register_nav_menus( array(
			'menu-main' => esc_html__( 'منوی اصلی', 'yahosein' ),
			'menu-footer' => esc_html__( 'منوی فوتر', 'yahosein' ),
	) );

	/*
	 * Switch default core markup for search form, comment form, and comments
	 * to output valid HTML5.
	 */
	add_theme_support( 'html5', array(
		'search-form',
		'comment-form',
		'comment-list',
		'gallery',
		'caption',
	) );

	// Set up the WordPress core custom background feature.
	add_theme_support( 'custom-background', apply_filters( 'yahosein_custom_background_args', array(
		'default-color' => 'ffffff',
		'default-image' => '',
	) ) );

	// Add theme support for selective refresh for widgets.
	add_theme_support( 'customize-selective-refresh-widgets' );

	add_image_size( 'slide-show', 860, 280 ,true);
	add_image_size( 'product-img', 250, 250 );
}
endif;
add_action( 'after_setup_theme', 'yahosein_setup' );

/**
 * Set the content width in pixels, based on the theme's design and stylesheet.
 *
 * Priority 0 to make it available to lower priority callbacks.
 *
 * @global int $content_width
 */
function yahosein_content_width() {
	$GLOBALS['content_width'] = apply_filters( 'yahosein_content_width', 640 );
}
add_action( 'after_setup_theme', 'yahosein_content_width', 0 );

/**
 * Register widget area.
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */
function yahosein_widgets_init() {

	register_sidebar( 
		array(
		'name'          => esc_html__( 'کنار سایت', 'yahosein' ),
		'id'            => 'sidebar',
		'description'   => esc_html__( 'برای نمایش آخرین ها،برترین ها و...', 'yahosein' ),
		'before_widget' => '<div class="col-md-4 col-sm-4 col-xs-12 %2$s  size_wrapper"><div id="%1$s" class="widget widget_wrapper ">',
		'after_widget'  => '</div></div></div>',
		'before_title'  => '<div class="widget_title widget-title  "><h3>',
		'after_title'   => '</h3></div> <div class="widget_content widget_content_border">',
	) 
		);
}
add_action( 'widgets_init', 'yahosein_widgets_init' );

/**
 * Enqueue scripts and styles.
 */
function yahosein_scripts() {
	global $yahosein;
	if(!isset($yahosein['opt-font-name']) || $yahosein['opt-font-name'] =='vazir' || empty($yahosein['opt-font-name']))
	{
		wp_enqueue_style( 'yahosein-style-font', get_template_directory_uri().'/layouts/vazir.min.css' );

	}else
	{
		wp_enqueue_style( 'yahosein-style-font', get_template_directory_uri().'/layouts/'.$yahosein['opt-font-name'].'.min.css' );

	}
	wp_enqueue_style( 'yahosein-style-bootstrap', get_template_directory_uri().'/layouts/bootstrap.min.css' );
	wp_enqueue_style( 'yahosein-style-bootstrap-rtl', get_template_directory_uri().'/layouts/bootstrap-rtl.min.css' );
	wp_enqueue_style( 'yahosein-font-awesome', get_template_directory_uri().'/layouts/font-awesome.min.css' );

	wp_enqueue_style( 'yahosein-style', get_template_directory_uri().'/layouts/custom.css' );

	wp_enqueue_script( 'yahosein-navigation', get_template_directory_uri() . '/js/navigation.js', array(), '20151215', true );
	wp_enqueue_script( 'yahosein-waypoints', get_template_directory_uri() . '/js/jquery.waypoints.min.js', array(), '20151215', true );
	wp_enqueue_script( 'yahosein-vticker', get_template_directory_uri() . '/js/jquery.vticker.min.js', array(), '20151215', true );

	wp_enqueue_script( 'yahosein-skip-link-focus-fix', get_template_directory_uri() . '/js/skip-link-focus-fix.js', array(), '20151215', true );

	wp_enqueue_script( 'yahosein-bootstrap-min', get_template_directory_uri() . '/js/bootstrap.min.js', array(), '20151215', true );
	if(is_home() || is_front_page())
	{
		wp_enqueue_script( 'yahosein-masonry.pkgd', get_template_directory_uri() . '/js/masonry.pkgd.min.js', array(), '20151215', true );	
	}
	wp_enqueue_script( 'yahosein-custom-min', get_template_directory_uri() . '/js/custom.min.js', array('jquery'), time(), true );



	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}
}
add_action( 'wp_enqueue_scripts', 'yahosein_scripts' );

/**
 * Load css customiztion from user settings
 */
function yahosein_custom_css()
{
	global $yahosein;
	$css = '';
	$main_color = $yahosein['opt-site-scheme'];
	if(empty($main_color)){$yahosein['opt-site-scheme']=$main_color='#c60909';  }

	//header bg
	$header_url = get_template_directory_uri().'/layouts/img/'.str_replace('#','',$main_color).'-header.png';
	$default_header_url = get_template_directory_uri().'/layouts/img/c60909-header.png';
	if($default_header_url != $yahosein['opt-header-img']['url'] && isset($yahosein['opt-header-img']['url']) && !empty($yahosein['opt-header-img']['url']))
	{
	    $header_url = $yahosein['opt-header-img']['url'];   
	}

		 // echo '<pre style="direction:ltr;">';
		 // 		var_dump($main_color);
		 // 		var_dump($header_url);
		 // echo '</pre>';
		 // die();

	$css .= '.header_mazhabi {
			background-image: url("'.$header_url.'");
	}';
	//logo
	// $header_logo_url = get_template_directory_uri().'/layouts/img/'.str_replace('#','',$main_color).'-logo.png';
	// if($header_logo_url != $yahosein['opt-header-logo']['url'] && isset($yahosein['opt-header-logo']['url']) && !empty($yahosein['opt-header-logo']['url']))
	// {
	//     $header_logo_url = $yahosein['opt-header-logo']['url'];   
	// }


	// $css .= '.site_main_logo {
	// 		background-image: url("'.$header_logo_url.'");
	// }';


	if(isset($yahosein['opt-site-scheme']) && !empty($yahosein['opt-site-scheme']))
	{
		$tire = yahosein_adjustBrightness($main_color,-100);
		$css .= '
		.site_main_logo{color: '.$tire .' !important;}
		.mazhabi_main_menu_navbar .meno_index_top .nav > .menu-item.active > a, .mazhabi_main_menu_navbar .meno_index_top .nav > .menu-item > a:hover, .mazhabi_main_menu_navbar .meno_index_top .nav > .menu-item > a:focus {
			color: '.$tire .' !important;
			border-color:  '.$tire .' !important;
		}
		.online_store_socials a:hover{color:'.$tire .' !important;}

			body.index .carousel_mazhabi .carousel .carousel-inner .carousel-caption
			{
				background-color : '.yahosein_adjustBrightness($main_color,-10) .';
				opacity:0.7;
			}
			.header_mazhabi .icon_header_mazhabi .history .online_store_socials a,
			.header_mazhabi .icon_header_mazhabi .history,
			body.index .index_contact_mazhabi .mahsolat_wrapper .widget_wrapper .widget_content .link_text li:active a,
			body.index .index_contact_mazhabi .mahsolat_wrapper .widget_wrapper .widget_content .link_text li:focus a,
			body.index .index_contact_mazhabi .mahsolat_wrapper .widget_wrapper .widget_content .link_text li:hover a,
			.index_contact_mazhabi .widget_content .new_news > li:active a,
			.index_contact_mazhabi .widget_content .new_news > li:focus a,
			.index_contact_mazhabi .widget_content .new_news > li:hover a,
			body.index .meno_tabi_mazhabi .tab-content .tab-pane li:focus a,
			body.index .meno_tabi_mazhabi .tab-content .tab-pane li:active a,
			body.index .meno_tabi_mazhabi .tab-content .tab-pane li:hover a,
			.breadcrumb,
			.online_store_main_content .comments-area .comment-respond .comment-form .open,
			.online_store_main_content .woocommerce-tabs .comment-list .comment .comment-content::before,
			.blog_news .category_module_item .text_news_box:hover h4 a,
			.blog_news .category_module_item .text_news_box:hover .post_info > li a,
			.online_store_main_content .content-area .posts_bottom_nav .pagination > li > a:active,
			.online_store_main_content .content-area .posts_bottom_nav .pagination > li > a:hover,
			.online_store_main_content .content-area .posts_bottom_nav .pagination > li > a:focus,
			.c-sections.online_store_main_content .online_store_product .product_meta span a:active,
			.c-sections.online_store_main_content .online_store_product .product_meta span a:focus,
			.c-sections.online_store_main_content .online_store_product .product_meta span a:hover,
			body.home .widget_content table a:active, body.home .widget_content table a:focus, body.home .widget_content table a:hover, body.home .widget_content li a:active, body.home .widget_content li a:focus, body.home .widget_content li a:hover ,
			.online_store_main_content .woocommerce-tabs .comment-list .comment .comment-meta .comment-author .reply::before
			{
			    color: '.$main_color.' !important;
			}

			.widget_wrapper .widget_content_background,
			.widget_text .widget_content,
			[id*="sokhane-bozorgan"] .widget_content,
			.widget_wrapper .widget_content_background,
			.widget_text .widget_content,
			[id*="sokhane-bozorgan"] .widget_content,
			.widget_wrapper .widget_content_background,
			.widget_text .widget_content,
			[id*="sokhane-bozorgan"] .widget_content,
			.widget_wrapper .widget_content_background,
			.widget_text .widget_content,
			[id*="sokhane-bozorgan"] .widget_content,
			.widget_wrapper .widget_content_background,
			.widget_text .widget_content,
			[id*="sokhane-bozorgan"] .widget_content,
			.barname_haftegi .widget_content
			{
			    background: linear-gradient( #ffffff,'.$main_color.') !important;
			}

			body.index .widget_title,
			.mazhabi_main_menu_navbar .meno_index_top,
			.scroll-top-wrapper:hover,
			body.index .index_contact_mazhabi .mahsolat_wrapper .widget_wrapper .widget_content .icon_hover,
			body.index .meno_tabi_mazhabi .nav > li > a:hover,
			body.index .meno_tabi_mazhabi .nav > li > a:focus,
			body.index .meno_tabi_mazhabi .nav-pills > li.active > a,
			body.index .meno_tabi_mazhabi .nav-pills > li.active > a:hover,
			body.index .meno_tabi_mazhabi .nav-pills > li.active > a:focus,
			.blog_news .category_module_item .product_hover,
			body.error .online_store_main_content .widget_wrapper .widget_content .error_text .bg_error,
			.mazhabi_main_menu_navbar .meno_index_top .navbar.meno_navar_bala .navbar-header .navbar-toggle .icon-bar,
			.hover_btn::after,
			.borobala:hover
			{
			    background-color: '.$main_color.' !important;
			}

			body.index .mahsolat_wrapper .widget_content,
			.widget_content_border,
			body.index .meno_tabi_mazhabi .meno-tabi,
			body.index .meno_tabi_mazhabi .nav.nav-pills a,
			body.page_index .khabar_nameh_business .c-newsletter-send.btn.btn_index,
			.blog_news .category_module_item
			{
			    border-color: '.$main_color.' !important;
			}
		.mazhabi_main_menu_navbar .meno_pic::before {
			background-image: url("'.get_template_directory_uri().'/layouts/img/'.str_replace('#','',$main_color).'-before.png");
		}
		.mazhabi_main_menu_navbar .meno_pic::after,body.index .widget_title::after  {
			background-image: url("'.get_template_directory_uri().'/layouts/img/'.str_replace('#','',$main_color).'-after.png");
		}



';

	}


	if(!empty($css))
	{
		echo '<style>';
		echo str_replace(array("\n"), '', $css);
		echo '</style>';
	}
}

add_action( 'wp_head', 'yahosein_custom_css' );

/**
 * Implement the Custom Header feature.
 */
require get_template_directory() . '/inc/custom-header.php';

/**
 * Custom template tags for this theme.
 */
require get_template_directory() . '/inc/template-tags.php';

/**
 * Custom functions that act independently of the theme templates.
 */
require get_template_directory() . '/inc/extras.php';

/**
 * Customizer additions.
 */
require get_template_directory() . '/inc/customizer.php';

/**
 * Load Jetpack compatibility file.
 */
require get_template_directory() . '/inc/jetpack.php';

/**
 * theme-options
 */
require get_template_directory() . '/inc/theme-options.php';


/**
 * Needed Plugins
 */
require get_template_directory() . '/inc/needed_plugins.php';

/**
 * Needed Plugins
 */
require get_template_directory() . '/inc/wp_bootstrap_navwalker.php';
/**
 * Widgets
 */
require get_template_directory() . '/inc/widgets.php';

/**
 * Post types
 */
require get_template_directory() . '/inc/post-types.php';

/**
 * Post meta
 */
require get_template_directory() . '/inc/post-meta.php';

/**
 * License
 */
require get_template_directory() . '/lic.php';

/**
 * Like system
 */
require get_template_directory() . '/inc/post-like.php';

