<?php
/**
 * The template for displaying the footer
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package yahosein
 */

global $yahosein;

$logo_url = get_template_directory_uri().'/layouts/img/logo.png';
if(isset($yahosein['opt-footer-logo']['url']) && !empty($yahosein['opt-footer-logo']['url']))
{
    $logo_url = $yahosein['opt-footer-logo']['url'];   
}


?>

    <footer class="c-sections mazhabi_footer ">
        <div class="container">
            <div class="row ">
                <div class="col-md-6 col-sm-6 col-xs-12 ">
                    <nav class="navbar meno_navar_bottom ">
                        <ul class="nav navbar-nav ">
                             <?php
                            if(has_nav_menu('menu-footer'))
                            {
                                $args = array(
                                    'container' => false,
                                    'theme_location' => 'menu-footer',
                                    'items_wrap' => '%3$s'
                                );
                                if(class_exists('wp_bootstrap_navwalker')){
                                    $args['walker']= new wp_bootstrap_navwalker();
                                }
                                wp_nav_menu($args);
                            }else
                            {
                                echo '<li><a href="'.admin_url('nav-menus.php' ).'">برای این قسمت منویی تعریف نشده،برای تعریف منو کلیک کنید</a></li>';
                            }
                            ?>
                        </ul>
                    </nav>
                </div>

                <div class="col-md-6 col-sm-6  col-xs-12 shabakeh_ejtemai_footer ">
                    <p class="online_store_socials">
                             <?php
                                $yahosein_socials = array(
                                    'facebook' => '',
                                    'instagram' => '',
                                    'google-pluse' => '',
                                    'telegram' => '',
                                    'whatsapp' => '',
                                    'android' => '',
                                    'windows' => '',
                                    );
                                global $yahosein;
                                foreach ($yahosein_socials as $class => $txt) {
                                    $s = '';
                                    if (isset($yahosein['opt-social-' . $class])) {
                                        $s = $yahosein['opt-social-' . $class];
                                    }

                                    if (!empty($s)) {
                                        if ($class == 'telegram') {
                                            $class = 'send';
                                        }

                                        echo '<a title="شبکه ی اجتماعی ' . $class . '" href="' . $s . '" class="  btn-social-icon btn-' . $class . '"><i class="fa fa-' . $class . '"></i></a>';
                                    }
                                }
                                if(isset($yahosein['opt-social-feed']) && $yahosein['opt-social-feed'] ==1){
                                ?><a title="فید سایت" href="<?php echo get_feed_link(); ?>" class="  btn-social-icon btn-rss"><i class="fa fa-rss"></i></a><?php }
                                if (!is_user_logged_in()) {
                                    if($yahosein['opt-social-reg']==1){
                                    ?><a title="عضویت در سایت" href="<?php echo wp_registration_url(); ?>" class="  btn-social-icon "><i class="fa fa-user-plus"></i></a><?php } if($yahosein['opt-social-login']==1){ ?><a title="ورود به سایت" href="<?php echo wp_login_url(home_url()); ?>" class=" btn-social-icon "><i class="fa fa-user"></i></a><?php }

                                }

                                ?>
                            </p>
                            </div>
                <div class="copyright col-md-12 col-sm-12  col-xs-12">
                    <hr class="khat_footer ">

                    <a rel="nofollow" title="گروه وب دیزاین" href="http://wd7.ir" class="shahabnet">کاری(♥) از گروه WD7</a>

                </div>
            </div>
        </div>
    </footer>
    <div class="scroll-top-wrapper ">
        <span class="scroll-top-inner ">
    <i class="fa fa-2x fa-arrow-circle-up "></i>
  </span>
    </div>
    </div>
    <?php wp_footer(); ?>
    <a href="#" class="borobala"><i class="bala fa-arrow-up fa"></i></a>
</body>
</html>
