<?php
/**
 * Template part for displaying page content in page.php
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package yahosein
 */

?>
<?php
/**
 * هماهنگی با پلاگین
 * https://wordpress.org/plugins/breadcrumb-navxt/
 */
if(function_exists('bcn_display'))
{
?>
<ul class="breadcrumb">
    <li><a href="<?php bloginfo('url' ); ?>"><i class="fa fa-home"></i></a></li>
    <?php bcn_display(); ?>
</ul>
<?php
}

     roman_setPostViews(get_the_ID());                


?>



<?php 
$post_info = '';
ob_start();
?>
  <ol class="post_info clearfix">
      <li class="date"><span class="fa  fa-calendar"></span><?php the_date(); ?></li>
      <li class="seeing"><span class="fa fa-eye"></span><span class="social_counts"><?php echo roman_getPostViews(get_the_ID()); ?></span></li>
      <?php 
        if(function_exists('get_simple_likes_button'))
        {
          echo get_simple_likes_button(get_the_ID()); 
        }
       ?>
      <!-- <li class="share"><a href="#" data-toggle="tooltip" title="به اشتراک بگذارید." data-placement="right"><span class="fa fa-share-alt"></span></a></li> -->
  </ol>
<?php
$post_info = ob_get_clean();

ob_start(); ?>
<?php 
$img_size = 'roman-small';
if(is_singular())
{
  $img_size = 'full';
}
the_post_thumbnail($img_size ,array('class'=>' img_book_roman img-responsive wp-post-image pic_news '));
?>
<?php
$roman_pic_wrp = ob_get_clean(); 
$roman_pic_wrp = trim($roman_pic_wrp);
if(empty($roman_pic_wrp) && isset($yahosein['opt-posts-default-pic']['url']))
{
  $roman_pic_wrp = '<img src="'.$yahosein['opt-posts-default-pic']['url'].'" class="pic_news img_book_roman '.' img-responsive wp-post-image" alt="" width="250" height="300">';
}




 $format = get_post_format( get_the_ID() );
 $post_class = array($format);
?>
	 	<article id="post-<?php the_ID(); ?>" <?php post_class($post_class); ?>>

<?php

 switch ( $format) {
 	case 'video':{
			$videos = get_attached_media( 'video', get_the_ID() );

 		?>
			<div class="widget_content">
            <div class="text_contect">
                <div class="film_mazhabi">
               		<?php 
              		if($videos && !empty($videos))
              		{
              			global $wp_embed;

              			foreach ($videos as $_dll) {
              					echo '<span class="file_title">'.$_dll->post_title.'</span>';
													$shortcode = '[embed]' . $_dll->guid . '[/embed]';
													$video = $wp_embed->run_shortcode($shortcode);
													echo do_shortcode($video);
													echo '<hr>';
              			}
              		}

              		 ?>
                </div>
                <h1 class="video_title"><?php the_title(); ?></h1>
								<?= $post_info ?>


                <div class="vone__desc">
								<?php the_excerpt(); ?>
                <div class="download_btn">
                		<?php 
                		if($videos && !empty($videos))
                		{
                			foreach ($videos as $_dll) {
                				echo '<a title="'.esc_attr( $_dll->post_title ).'" href="'.$_dll->guid.'" class="btn hover_btn high_quality">دانلود 	 <span class="in_file_title"><i class="fa-video-camera fa"></i>'. $_dll->post_title.'</span></a>';
                			}
                		}

                		 ?>
                    <div class="clearfix"></div>
                </div>

            </div>
        </div>
 		<?php
 	}break;
 	case 'audio':{
 		$audios = get_attached_media( 'audio', get_the_ID() );
 		?>
			<div class="widget_content">
            <div class="text_contect">
                <div class="music_mazhabi">
										<?php echo $roman_pic_wrp; ?>
                 		<?php 
                		if($audios && !empty($audios))
                		{
                			global $wp_embed;

                			foreach ($audios as $_dll) {
                					echo '<span class="file_title">'.$_dll->post_title.'</span>';
														$shortcode = '[embed]' . $_dll->guid . '[/embed]';
														$video = $wp_embed->run_shortcode($shortcode);
														echo do_shortcode($video);
														echo '<hr>';
                			}
                		}

                		 ?>

                </div>
                <h1 class="video_title"><?php the_title(); ?></h1>
								<?php 
								echo $post_info;
								 ?>


                <div class="vone__desc">
                 <?php the_excerpt(); ?>
                 </div>

                <div class="download_btn">
                		<?php 
                		if($audios && !empty($audios))
                		{
                			foreach ($audios as $_dll) {
                				echo '<a title="'.esc_attr( $_dll->post_title ).'" href="'.$_dll->guid.'" class="btn hover_btn high_quality">دانلود 	 <span class="in_file_title"><i class="fa-music fa"></i>'. $_dll->post_title.'</span></a>';
                			}
                		}

                		 ?>
                    <div class="clearfix"></div>
                </div>

            </div>
        </div>
 		<?php
 	}break;
 	default:{
 		?>
		<?php  roman_setPostViews(get_the_ID());   ?>
		<header class="entry-header">
			<?php the_title( '<h1 class="entry-title">', '</h1>' ); ?>
			<p class="sub_text"><?php yahosein_posted_on(); ?></p>
		</header><!-- .entry-header -->

		<div class="entry-content">
	     <div class="single_img  roman_pic_wrp"><?=$roman_pic_wrp?></div>

			<?php
				the_content();
				echo $post_info;
				wp_link_pages( array(
					'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'yahosein' ),
					'after'  => '</div>',
				) );
			?>
		</div><!-- .entry-content -->

		<?php if ( get_edit_post_link() ) : ?>
			<footer class="entry-footer">
				<?php
					edit_post_link(
						sprintf(
							/* translators: %s: Name of current post */
							esc_html__( 'Edit %s', 'yahosein' ),
							the_title( '<span class="screen-reader-text">"', '"</span>', false )
						),
						'<span class="edit-link">',
						'</span>'
					);
				?>
			</footer><!-- .entry-footer -->
		<?php endif; ?>

 		<?php
 	}break;
 }
 ?>
 	</article><!-- #post-## -->

  <div class="product_meta">
      <hr>
      <span class="tagged_as"><?php the_terms( get_the_ID(), 'post_tag', '<i class="fa fa-tag"></i> برچسب: ', ', ', '' ); ?></span>
      <span class="posted_in"><?php the_terms( get_the_ID(), 'category', '<i class="fa fa-tags"></i> دسته: ', ', ', '' ); ?></span>
  </div>
	<?php 
		if (comments_open() || get_comments_number()):
			echo '<div class="woocommerce-tabs wc-tabs-wrapper">';
			comments_template();
			echo '</div>';
		endif;
	 ?>

