<?php
defined('ABSPATH') or die('No script kiddies please!');

add_action( 'widgets_init', 'roman_reg_hesab' );
function roman_reg_hesab() {

	register_widget( 'yahosein_widget_hesab' );

}

class yahosein_widget_hesab extends WP_Widget {
	private static $widget_id;

	/*  Constructor
	/* ------------------------------------ */
	function __construct() {
		parent::__construct(false, __('A_wd7:: شماره حساب ها', 'yahosein'), array('description' => __('::wd7::نمایش شماره حساب ها', 'yahosein'), 'classname' => 'yahosein_widget_hesab news-min-1 widget'));
	}

	/**
	 * Front-end display of widget.
	 *
	 * @see WP_Widget::widget()
	 *
	 * @param array $args Widget arguments.
	 * @param array $instance Saved values from database.
	 */
	public function widget($args, $instance) {
		self::$widget_id = $args['widget_id'];
		echo $args['before_widget'];
		echo $args['before_title'] . apply_filters('widget_title', $instance['title']) . $args['after_title'] ;

		$this->tabsContent($instance);
		echo $args['after_widget'];
	}

	public function tabsContent($args) {

		$title = $args['title'];
		$hesabha = $args['hesabha'];
		?>
		<ul class="shomareh_hesab">
				<?php echo wpautop(stripcslashes($hesabha)); ?>
		    <li class="widget_img_center">
		        <aside class="pic_shabak">
		            <img src="<?php echo get_template_directory_uri() ?>/layouts/img/shabakpng.png" alt="شتاب" class="shabak">
		        </aside>
		    </li>
			</ul>

		<?php

	}

	/**
	 * Back-end widget form.
	 *
	 * @see WP_Widget::form()
	 *
	 * @param array $instance Previously saved values from database.
	 */
	public function form($instance) {
		$title = !empty($instance['title']) ? $instance['title'] : __('شماره حساب ها جهت نذورات', 'yahosein');
		$hesabha = !empty($instance['hesabha']) ? $instance['hesabha'] : '';
		?>
		<style>
			.yahosein-cat-slider{ padding:3px; border:1px solid #bbb; border-radius:3px; margin:5px; }
			.yahosein-cat-slider select {  max-width: 100%; }
		</style>
		<p>
			<label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('عنوان:');?></label>
			<input class="widefat" id="<?php echo $this->get_field_id('title'); ?>"
			name="<?php echo $this->get_field_name('title'); ?>" type="text"
			value="<?php echo esc_attr($title); ?>">
		</p>
		<p>
			<label for="<?php echo $this->get_field_id('hesabha'); ?>"><?php _e('توضیحات حساب ها:');?></label>
			<textarea class="widefat" id="<?php echo $this->get_field_id('hesabha'); ?>"
			name="<?php echo $this->get_field_name('hesabha'); ?>"><?php echo esc_attr($hesabha); ?></textarea>

		</p>

		<?php

	}

	/**
	 * Sanitize widget form values as they are saved.
	 *
	 * @see WP_Widget::update()
	 *
	 * @param array $new_instance Values just sent to be saved.
	 * @param array $old_instance Previously saved values from database.
	 *
	 * @return array Updated safe values to be saved.
	 */
	public function update($new_instance, $old_instance) {
		$instance = array();
		$instance['title'] = (!empty($new_instance['title'])) ? strip_tags($new_instance['title']) : 'شماره حساب ها جهت نذورات';
		$instance['hesabha'] = (!empty($new_instance['hesabha'])) ? strip_tags($new_instance['hesabha']) : '';

		return $instance;
	}


}
