<?php
defined('ABSPATH') or die('No script kiddies please!');

add_action('widgets_init', 'roman_tazetarin_archive');
function roman_tazetarin_archive() {

	register_widget('yahosein_widget_tazetarin');

}

class yahosein_widget_tazetarin extends WP_Widget {
	private static $widget_id;

	/*  Constructor
	/* ------------------------------------ */
	function __construct() {
		parent::__construct(false, __('A_wd7:: تازه ترین', 'yahosein'), array('description' => __('::wd7::نمایش تازه ترین ', 'yahosein'), 'classname' => 'yahosein_widget_tazetarin  mahsolat_wrapper'));
	}

	/**
	 * Front-end display of widget.
	 *
	 * @see WP_Widget::widget()
	 *
	 * @param array $args Widget arguments.
	 * @param array $instance Saved values from database.
	 */
	public function widget($args, $instance) {
		self::$widget_id = $args['widget_id'];
		echo $args['before_widget'];
		echo $args['before_title'] . apply_filters('widget_title', $instance['title']) . $args['after_title'];

		$this->tabsContent($instance);
		echo $args['after_widget'];
	}

	public function tabsContent($args) {

		$title = $args['title'];
		$cat = $args['cat'];
		$num=4;
		 ?>
                           

		<?php 
		$counter = 0;
		$args = array('posts_per_page' => $num,'cat'=>$cat);
		$q = new wp_query($args);
		if ($q->have_posts()) {
				echo '<ul class="link_text">';
					while($q->have_posts())
					{
						$q->the_post();
						ob_start(); ?>
						<?php 
						$img_size = 'roman-small';
						if(is_singular())
						{
						  $img_size = 'full';
						}
						the_post_thumbnail($img_size ,array('class'=>' pic_khabari_min img-responsive wp-post-image  '));
						?>
						<?php
						$roman_pic_wrp = ob_get_clean(); 
						$roman_pic_wrp = trim($roman_pic_wrp);
						if(empty($roman_pic_wrp) && isset($yahosein['opt-posts-default-pic']['url']))
						{
						  $roman_pic_wrp = '<img src="'.$yahosein['opt-posts-default-pic']['url'].'" class="pic_khabari_min   '.' img-responsive wp-post-image" alt="" width="250" height="300">';
						}



						if($counter==0)
						{
							?>
		        <li>
		        		<?php echo $roman_pic_wrp; ?>
		            <h5><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h5> <?php echo wp_trim_words(get_the_excerpt(),14); ?>
		        </li>
							<?php
						}else{
							?>
							<li><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></li>
							<?php							
						}

						$counter++;
						echo '<hr>';						

					}
				echo '</ul>';
		}else
		{
			echo '<li>فاقد مطلب</li>';
		}

		 ?>

    <div class="clearfix"></div>

                            
		<?php

	}

	/**
	 * Back-end widget form.
	 *
	 * @see WP_Widget::form()
	 *
	 * @param array $instance Previously saved values from database.
	 */
	public function form($instance) {
		$title = !empty($instance['title']) ? $instance['title'] : __('تازه ترین', 'yahosein');
		$num = !empty($instance['num']) ? $instance['num'] : 5;
		$cat = !empty($instance['cat']) ? $instance['cat'] : 0;
		?>
		<style>
			.yahosein-cat-slider{ padding:3px; border:1px solid #bbb; border-radius:3px; margin:5px; }
			.yahosein-cat-slider select {  max-width: 100%; }
		</style>
		<p>
			<label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('عنوان:');?></label>
			<input class="widefat" id="<?php echo $this->get_field_id('title'); ?>"
			name="<?php echo $this->get_field_name('title'); ?>" type="text"
			value="<?php echo esc_attr($title); ?>">
		</p>
		<p>
			<label for="<?php echo $this->get_field_id('cat'); ?>"><?php _e('دسته:');?></label>
			<?php echo yahosein_get_categories_select_html($this->get_field_name('cat'), $cat); ?>
		</p>



		<?php

	}

	/**
	 * Sanitize widget form values as they are saved.
	 *
	 * @see WP_Widget::update()
	 *
	 * @param array $new_instance Values just sent to be saved.
	 * @param array $old_instance Previously saved values from database.
	 *
	 * @return array Updated safe values to be saved.
	 */
	public function update($new_instance, $old_instance) {
		$instance = array();
		$instance['title'] = (!empty($new_instance['title'])) ? strip_tags($new_instance['title']) : 'تازه ترین';
		$instance['num'] = (!empty($new_instance['num'])) ? $new_instance['num'] : 5;
		$instance['cat'] = (!empty($new_instance['cat'])) ? $new_instance['cat'] : '';

		return $instance;
	}

}
