<?php
defined('ABSPATH') or die('No script kiddies please!');

add_action('widgets_init', 'roman_recent_from_archive');
function roman_recent_from_archive() {

	register_widget('yahosein_widget_ganjine');

}

class yahosein_widget_ganjine extends WP_Widget {
	private static $widget_id;

	/*  Constructor
	/* ------------------------------------ */
	function __construct() {
		parent::__construct(false, __('A_wd7:: گنجینه', 'yahosein'), array('description' => __('::wd7::نمایش گنجینه ', 'yahosein'), 'classname' => 'yahosein_widget_ganjine  mahsolat_wrapper'));
	}

	/**
	 * Front-end display of widget.
	 *
	 * @see WP_Widget::widget()
	 *
	 * @param array $args Widget arguments.
	 * @param array $instance Saved values from database.
	 */
	public function widget($args, $instance) {
		self::$widget_id = $args['widget_id'];
		echo $args['before_widget'];
		echo $args['before_title'] . apply_filters('widget_title', $instance['title']) . $args['after_title'];

		$this->tabsContent($instance);
		echo $args['after_widget'];
	}

	public function tabsContent($args) {

		$title = $args['title'];
		$cat = $args['cat'];
		$icon = $args['icon'];
		$num=2;
		 ?>
    <a href="<?php echo get_category_link($cat); ?>" class="fa <?= $icon ?> icon_hover"></a>
		<?php 
		$args = array('posts_per_page' => $num,'cat'=>$cat);
		$q = new wp_query($args);
		if ($q->have_posts()) {
				echo '<ul class="link_text">';
					while($q->have_posts())
					{
						$q->the_post();
						?>
	        <li> <a class="min_text_link" href="<?php the_permalink(); ?>"><h5><?php the_title(); ?></h5></a>
	            <aside class="min_text"><?php echo wp_trim_words(get_the_excerpt(),7); ?></aside>
	        </li>
						<?php
					}
				echo '</ul>';
		}else
		{
			echo '<li>فاقد مطلب</li>';
		}

		 ?>

    <a class="btn hover_btn pull-left" href="<?php echo get_category_link($cat); ?>">آرشیو</a>
    <div class="clearfix"></div>

                            
		<?php

	}

	/**
	 * Back-end widget form.
	 *
	 * @see WP_Widget::form()
	 *
	 * @param array $instance Previously saved values from database.
	 */
	public function form($instance) {
		$title = !empty($instance['title']) ? $instance['title'] : __('گنجینه', 'yahosein');
		$num = !empty($instance['num']) ? $instance['num'] : 5;
		$cat = !empty($instance['cat']) ? $instance['cat'] : 0;
		$icon = !empty($instance['icon']) ? $instance['icon'] : 0;
		?>
		<style>
			.yahosein-cat-slider{ padding:3px; border:1px solid #bbb; border-radius:3px; margin:5px; }
			.yahosein-cat-slider select {  max-width: 100%; }
		</style>
		<p>
			<label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('عنوان:');?></label>
			<input class="widefat" id="<?php echo $this->get_field_id('title'); ?>"
			name="<?php echo $this->get_field_name('title'); ?>" type="text"
			value="<?php echo esc_attr($title); ?>">
		</p>
		<p>
			<label for="<?php echo $this->get_field_id('cat'); ?>"><?php _e('دسته:');?></label>
			<?php echo yahosein_get_categories_select_html($this->get_field_name('cat'), $cat); ?>
		</p>
		<!-- which icon -->
		<p>
			<label for="<?php echo $this->get_field_id('icon'); ?>"><?php _e('آیکن:');?></label>
			<?php
			// echo yahosein_get_fontawesome_select_html($this->get_field_name('icon'), $icon, 0);
			?>
			<select id="<?php echo $this->get_field_id('icon'); ?>" name="<?php echo $this->get_field_name('icon'); ?>">
				<option <?php selected( $icon, 'fa-music', $echo = true ); ?> value="fa-music">آیکن صوت</option>
				<option <?php selected( $icon, 'fa-video-camera', $echo = true ); ?> value="fa-video-camera">آیکن فیلم</option>
				<option <?php selected( $icon, 'fa-image', $echo = true ); ?> value="fa-image">آیکن عکس</option>
				<option <?php selected( $icon, 'fa-bullhorn', $echo = true ); ?> value="fa-bullhorn">آیکن بلندگو</option>
				<option <?php selected( $icon, 'fa-bolt', $echo = true ); ?> value="fa-bolt">آیکن رعد و برق</option>
				<option <?php selected( $icon, 'fa-bars', $echo = true ); ?> value="fa-bars">آیکن منو</option>
				<option <?php selected( $icon, 'fa-area-chart', $echo = true ); ?> value="fa-area-chart">آیکن نمودار</option>
				<option <?php selected( $icon, 'fa-archive', $echo = true ); ?> value="fa-archive">آیکن آرشیو</option>
				<option <?php selected( $icon, 'fa-gear', $echo = true ); ?> value="fa-gear">آیکن چرخ دنده</option>
				<option <?php selected( $icon, 'fa-star', $echo = true ); ?> value="fa-star">آیکن ستاره</option>
			</select>
		</p>


		<?php

	}

	/**
	 * Sanitize widget form values as they are saved.
	 *
	 * @see WP_Widget::update()
	 *
	 * @param array $new_instance Values just sent to be saved.
	 * @param array $old_instance Previously saved values from database.
	 *
	 * @return array Updated safe values to be saved.
	 */
	public function update($new_instance, $old_instance) {
		$instance = array();
		$instance['title'] = (!empty($new_instance['title'])) ? strip_tags($new_instance['title']) : 'گنجینه';
		$instance['num'] = (!empty($new_instance['num'])) ? $new_instance['num'] : 5;
		$instance['cat'] = (!empty($new_instance['cat'])) ? $new_instance['cat'] : '';
		$instance['icon'] = (!empty($new_instance['icon'])) ? $new_instance['icon'] : 'fa-gear';

		return $instance;
	}

}
