<?php

defined('ABSPATH') or die('No script kiddies please!');

/**
 * Main Core
 */
if (!class_exists('ReduxFrameworkInstances')) {
	require_once 'redux-framework/ReduxCore/framework.php';
}
/**
 * Redux Extensions
 */
require_once get_template_directory() . '/inc/redux-extensions-loader-master/loader.php';

/**
 * ReduxFramework Sample Config File
 * For full documentation, please visit: http://docs.reduxframework.com/
 */

if (!class_exists('Redux')) {
	return;
}

// This is your option name where all the Redux data is stored.
$opt_name = "yahosein";

// This line is only for altering the demo. Can be easily removed.
$opt_name = apply_filters('yahosein/opt_name', $opt_name);

/**
 * Main Theme config And settings
 */
do_action('filepress_config', $opt_name);
do_action('yahosein_config', $opt_name);
/**
 * تنظیمات قالب
 */
/**
 * ---> SET ARGUMENTS
 * All the possible arguments for Redux.
 * For full documentation on arguments, please refer to: https://github.com/ReduxFramework/ReduxFramework/wiki/Arguments
 * */

$theme = wp_get_theme(); // For use with some settings. Not necessary.

$args = array(
	// TYPICAL -> Change these values as you need/desire
	'opt_name' => $opt_name,
	'disable_tracking' => true,
	// This is where your data is stored in the database and also becomes your global variable name.
	'display_name' => $theme->get('Name'),
	// Name that appears at the top of your panel
	'display_version' => $theme->get('Version'),
	// Version that appears at the top of your panel
	'menu_type' => 'menu',
	//Specify if the admin menu should appear or not. Options: menu or submenu (Under appearance only)
	'allow_sub_menu' => true,
	// Show the sections below the admin menu item or not
	'menu_title' => __('تنظیمات قالب', 'yahosein'),
	'page_title' => __('تنظیمات قالب', 'yahosein'),
	// You will need to generate a Google API key to use this feature.
	// Please visit: https://developers.google.com/fonts/docs/developer_api#Auth
	'google_api_key' => '',
	// Set it you want google fonts to update weekly. A google_api_key value is required.
	'google_update_weekly' => false,
	// Must be defined to add google fonts to the typography module
	'async_typography' => true,
	// Use a asynchronous font on the front end or font string
	//'disable_google_fonts_link' => true,                    // Disable this in case you want to create your own google fonts loader
	'admin_bar' => true,
	// Show the panel pages on the admin bar
	'admin_bar_icon' => 'dashicons-portfolio',
	// Choose an icon for the admin bar menu
	'admin_bar_priority' => 50,
	// Choose an priority for the admin bar menu
	'global_variable' => '',
	// Set a different name for your global variable other than the opt_name
	'dev_mode' => false,
	// Show the time the page took to load, etc
	'update_notice' => true,
	// If dev_mode is enabled, will notify developer of updated versions available in the GitHub Repo
	'customizer' => true,
	// Enable basic customizer support
	//'open_expanded'     => true,                    // Allow you to start the panel in an expanded way initially.
	//'disable_save_warn' => true,                    // Disable the save warning when a user changes a field

	// OPTIONAL -> Give you extra features
	'page_priority' => null,
	// Order where the menu appears in the admin area. If there is any conflict, something will not show. Warning.
	'page_parent' => 'themes.php',
	// For a full list of options, visit: http://codex.wordpress.org/Function_Reference/add_submenu_page#Parameters
	'page_permissions' => 'manage_options',
	// Permissions needed to access the options panel.
	'menu_icon' => '',
	// Specify a custom URL to an icon
	'last_tab' => '',
	// Force your panel to always open to a specific tab (by id)
	'page_icon' => 'icon-themes',
	// Icon displayed in the admin panel next to your menu_title
	'page_slug' => 'yahosein',
	// Page slug used to denote the panel, will be based off page title then menu title then opt_name if not provided
	'save_defaults' => true,
	// On load save the defaults to DB before user clicks save or not
	'default_show' => false,
	// If true, shows the default value next to each field that is not the default value.
	'default_mark' => '',
	// What to print by the field's title if the value shown is default. Suggested: *
	'show_import_export' => true,
	// Shows the Import/Export panel when not used as a field.

	// CAREFUL -> These options are for advanced use only
	'transient_time' => 60 * MINUTE_IN_SECONDS,
	'output' => true,
	// Global shut-off for dynamic CSS output by the framework. Will also disable google fonts output
	'output_tag' => true,
	// Allows dynamic CSS to be generated for customizer and google fonts, but stops the dynamic CSS from going to the head
	// 'footer_credit'     => '',                   // Disable the footer credit of Redux. Please leave if you can help it.

	// FUTURE -> Not in use yet, but reserved or partially implemented. Use at your own risk.
	'database' => '',
	// possible: options, theme_mods, theme_mods_expanded, transient. Not fully functional, warning!
	'use_cdn' => true,
	// If you prefer not to use the CDN for Select2, Ace Editor, and others, you may download the Redux Vendor Support plugin yourself and run locally or embed it in your code.
	// HINTS
	'hints' => array(
		'icon' => 'el el-question-sign',
		'icon_position' => 'right',
		'icon_color' => 'lightgray',
		'icon_size' => 'normal',
		'tip_style' => array(
			'color' => 'red',
			'shadow' => true,
			'rounded' => false,
			'style' => '',
		),
		'tip_position' => array(
			'my' => 'top left',
			'at' => 'bottom right',
		),
		'tip_effect' => array(
			'show' => array(
				'effect' => 'slide',
				'duration' => '500',
				'event' => 'mouseover',
			),
			'hide' => array(
				'effect' => 'slide',
				'duration' => '500',
				'event' => 'click mouseleave',
			),
		),
	),
);

// ADMIN BAR LINKS -> Setup custom links in the admin bar menu as external items.
$args['admin_bar_links'][] = array(
	'id' => 'yahosein-support',
	'href' => 'http://shahab-net.ir/?support',
	'title' => __('پشتیبانی قالب', 'yahosein'),
);

$args['admin_bar_links'][] = array(
	'id' => 'yahosein-order',
	'href' => 'http://shahab-net.ir/?order',
	'title' => __('سفارش وب سایت', 'yahosein'),
);

$args['admin_bar_links'][] = array(
	'id' => 'yahosein-tuts',
	'href' => 'http://shahab-net.ir/?tuts',
	'title' => __('مطالب آموزشی وردپرس', 'yahosein'),
);

// Panel Intro text -> before the form
if (!isset($args['global_variable']) || $args['global_variable'] !== false) {
	if (!empty($args['global_variable'])) {
		$v = $args['global_variable'];
	} else {
		$v = str_replace('-', '_', $args['opt_name']);
	}
	$args['intro_text'] = __('<p> <a href="http://wd7.ir/docs/wp-theme-yahosein-doc">راهنمای قالب</a>  |  <a href="http://wd7.ir/support">پشتیبانی</a> </p>', 'yahosein');
} else {
	$args['intro_text'] = __('<p> <a href="http://wd7.ir/docs/wp-theme-yahosein-doc">راهنمای قالب</a>  |  <a href="http://wd7.ir/support">پشتیبانی</a> </p>', 'yahosein');
}

// Add content after the form.
$args['footer_text'] = __('<p>وب دیزاین ارائه دهنده خدمات برنامه نویسی تحت وب / راهکاری های فروشگاهی / شخصی / شرکتی / دولتی</p>', 'yahosein');

Redux::setArgs($opt_name, $args);

/**
 * قسمت های مختلف تنظیمات قالب
 */
$main_color = '#c60909';

Redux::setSection($opt_name, array(
	'title' => __('لوگو / هدر / تصاویر', 'yahosein'),
	'icon' => 'el el-picture',
	'fields' => array(
		array(
			'id' => 'opt-header-img',
			'type' => 'media',
			'title' => __('هدر', 'yahosein'),
			'output' => array('.site-header'),
			'desc' => __(' اندازه توصیه شده « 1500x362', 'yahosein'),
			'default' => array('url' => get_template_directory_uri().'/layouts/img/'.str_replace('#','',$main_color).'-header.png'),
		),
	),
));

Redux::setSection($opt_name, array(
	'title' => __('شبکه های اجتماعی', 'yahosein'),
	'icon' => 'el el-googleplus',
	'fields' => array(
		array(
			'id' => 'opt-social-facebook',
			'type' => 'text',
			'title' => __('آدرس صفحه facebook', 'yahosein'),
			'desc' => __('آدرس مربوط به facebook خود را وارد نمایید ، در صورت خالی گذاشتن در سایت نمایش داده نمی شود.', 'yahosein'),
		), array(
			'id' => 'opt-social-instagram',
			'type' => 'text',
			'title' => __('آدرس صفحه instagram', 'yahosein'),
			'desc' => __('آدرس مربوط به instagram خود را وارد نمایید ، در صورت خالی گذاشتن در سایت نمایش داده نمی شود.', 'yahosein'),
		), array(
			'id' => 'opt-social-googlepluse',
			'type' => 'text',
			'title' => __('آدرس صفحه Google Plus', 'yahosein'),
			'desc' => __('آدرس مربوط به Google Plus خود را وارد نمایید ، در صورت خالی گذاشتن در سایت نمایش داده نمی شود.', 'yahosein'),
		), array(
			'id' => 'opt-social-telegram',
			'type' => 'text',
			'title' => __('آدرس صفحه تلگرام', 'yahosein'),
			'desc' => __('آدرس مربوط به تلگرام خود را وارد نمایید ، در صورت خالی گذاشتن در سایت نمایش داده نمی شود.', 'yahosein'),
		),
		array(
			'id' => 'opt-social-whatsapp',
			'type' => 'text',
			'title' => __('واتساپ', 'redux-framework-demo'),
		),
		array('type' => 'divide', 'id' => 'divide_socials'),
		array(
			'id' => 'opt-social-android',
			'type' => 'text',
			'title' => __('اندروید', 'redux-framework-demo'),
		),
		array(
			'id' => 'opt-social-apple',
			'type' => 'text',
			'title' => __('اپل', 'redux-framework-demo'),
		),
		array(
			'id' => 'opt-social-windows',
			'type' => 'text',
			'title' => __('ویندوز فون', 'redux-framework-demo'),
		),
		array('type' => 'divide', 'id' => 'divide_feed'),

		array(
			'id' => 'opt-social-feed',
			'type' => 'checkbox',
			'default' => 1,
			'title' => __('نمایش آیکن فید در کنار شبکه های اجتماعی؟', 'redux-framework-demo'),
		),
		array(
			'id' => 'opt-social-login',
			'type' => 'checkbox',
			'default' => 1,
			'title' => __('نمایش آیکن ورود در کنار شبکه های اجتماعی؟', 'redux-framework-demo'),
		),
		array(
			'id' => 'opt-social-reg',
			'type' => 'checkbox',
			'default' => 1,
			'title' => __('نمایش آیکن ثبت نام در کنار شبکه های اجتماعی؟', 'redux-framework-demo'),
		),

	),
));


if(defined('FILEPRESS_MOKAMEL')){

Redux::setSection($opt_name, array(
	'title' => __('فونت سایت', 'yahosein'),
	'icon'  => 'el el-font',

	'fields' => array(
		array(
			'id' => 'opt-font-name',
			'type' => 'select',
			'options' => array('vazir' => 'فونت وزیر', 'yekan' => 'فونت یکان', 'irsans' => 'ایران سنس'),
			'default' => 'vazir',
			'title' => __('فونت سایت', 'yahosein'),
			'desc' => __('میتوانید فونت مورد استفاده در سایت را تغییر دهید', 'yahosein'),
		),
	),
));
}else{
	Redux::setSection($opt_name, array(
	'title' => __('فونت سایت', 'yahosein'),
	'icon'  => 'el el-font',

	'fields' => array(
		array(
			'id' => 'opt-font-name-info',
			'type' => 'info',
			'style' => 'success',
			'icon'=>'el el-heart-empty',
			'title'=>'تنظیم فونت های بیشتر',
			'desc' => __('این مورد فقط در نسخه مکمل وجود دارد ، جهت خرید کلیک کنید: <a class="button button-primary" href="http://wd7.ir/?post_type=product&p=1497">خرید</a>', 'yahosein'),
		),
	),
));
}



Redux::setSection($opt_name, array(
	'title' => __('اسلایدشو', 'yahosein'),
	'icon'=>'el el-photo',
	'fields' => array(
		array(
			'id' => 'opt-slide-cat',
			'type' => 'select',
			'title' => __('دسته اسلایدشو', 'yahosein'),
			'desc' => 'طرح های این دسته در صفحه اول قرار خواهند گرفت',
			'data' => 'categories',
			'args' => array(
				'hide_empty' => 0,
				// 'selected'         => -1,
			)),
		array(
			'id' => 'opt-slide-enable',
			'type' => 'checkbox',
			'title' => __('فعال بودن اسلایدشو', 'yahosein'),
			'desc' => 'اگر غیرفعال باشد نمایش داده نمی شود.',
			'default' => 1,
		),
		array(
			'id' => 'opt-slide-enable-caption',
			'type' => 'checkbox',
			'title' => __('فعال بودن نوشته روی تصاویر', 'yahosein'),
			'desc' => 'اگر غیرفعال باشد نمایش داده نمی شود.',
			'default' => 1,
		),

	),
));
$yahosein_opt = get_option('yahosein');
$cat_fields = array();
$cat_fields[] =
array(
	'id' => 'opt-footer-cat-enable',
	'type' => 'checkbox',
	'title' => __('فعال بودن نمایش در فوتر', 'yahosein'),
	'desc' => 'اگر تیک داشته باشند نمایش داده می شود.',
	'default' => 1,
);
$cat_fields[] =
array(
	'id' => 'opt-footer-cat-num',
	'type' => 'text',
	'title' => __('تعداد دسته بندی ها', 'yahosein'),
	'desc' => 'تعداد بخش ها برای نماش در صفحه اول ، لطفا بعد از ذخیره صفحه را رفرش کنید و مجدد مراجعه کنید',
	'default' => 3,
);
$num = isset($yahosein_opt['opt-footer-cat-num'])?$yahosein_opt['opt-footer-cat-num']:3;
for ($i = 0; $i < $num; $i++) {
	$cat_fields[] =
	array
		(
		'id' => 'opt-footer-cat-' . $i,
		'type' => 'select',
		'title' => __('انتخاب دسته بندی', 'yahosein'),
		'data' => 'terms',
		'args' => array(
			'hide_empty' => 0,
			'taxonomies' => array('category'),
			// 'selected'         => -1,
		),
		'desc' => 'تنظیم بخش ' . $i . ' م',
	);
}

Redux::setSection($opt_name, array(
	'title' => __('مطالب در فوتر', 'yahosein'),
	'icon'=>'el el-home',
	'fields' => $cat_fields,

));



if(defined('FILEPRESS_MOKAMEL')){

Redux::setSection($opt_name, array(
	'title' => __('رنگ بندی سایت', 'yahosein'),
	'icon' => 'el el-screen',
	'fields' => array(
		array(
			'id' => 'opt-site-scheme',
			'type' => 'select',
			'options' => array('#c60909' => 'قرمز', '#333333' => 'مشکی', '#EF9B1E' => 'زرد','#77a107' => 'سبز','#00c2a9' => 'آبی'),
			'title' => __('رنگ مکمل سایت', 'yahosein'),
			'desc' => 'در انتخاب رنگ مکمل دقت کنید که با رنگ اصلی ست باشد ',
			'default' => '#c60909',
		),
	),

));
}else{
Redux::setSection($opt_name, array(
	'title' => __('رنگ بندی سایت', 'yahosein'),
	'icon' => 'el el-screen',

	'fields' => array(
			array(
			'id' => 'opt-colors-info',
			'type' => 'info',
			'style' => 'success',
			'icon'=>'el el-heart-empty',
			'title'=>'رنگ بندی دلخواه سایت',
			'desc' => __('این مورد فقط در نسخه مکمل وجود دارد ، جهت خرید کلیک کنید: <a class="button button-primary" href="http://wd7.ir/?post_type=product&p=1497">خرید</a>', 'yahosein'),
		),
	),

));

}

