<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package yahosein
 */
global $yahosein;
?><!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
<meta charset="<?php bloginfo( 'charset' ); ?>">
<meta http-equiv="X-UA-Compatible" content="IE=edge">    
<meta name="viewport" content="width=device-width, initial-scale=1">
<link rel="profile" href="http://gmpg.org/xfn/11">
<?php 
 if(isset($yahosein['opt-favicon']['url']) && $yahosein['opt-favicon']['url'] !='')
 {
    ?>
    <link rel="icon" type="image/png" href="<?php echo $yahosein['opt-favicon']['url']; ?>">
    <link rel="shortcut icon" href="<?php echo $yahosein['opt-favicon']['url']; ?>"/>
    <?php
 }
 ?>
 <?php
	$main_color = $yahosein['opt-site-scheme'];
	if(!empty($main_color))
	{
			echo '<meta name="theme-color" content="'.$main_color.'" />';
	}

 ?>


<?php wp_head(); ?>
    <!--[if lt IE 9]>
        <script src="https://oss.maxcdn.com/libs/html5shiv/3.7.0/html5shiv.js"></script>
        <script src="https://oss.maxcdn.com/libs/respond.js/1.4.2/respond.min.js"></script>
    <![endif]-->  


</head>
<?php 
$header_url = get_template_directory_uri().'/layouts/img/header.png';
if(isset($yahosein['opt-header-img']['url']) && !empty($yahosein['opt-header-img']['url']))
{
    $header_url = $yahosein['opt-header-img']['url'];   
}
$body_class = ' index ';
 ?>
<body id="i-am-top-of-page" <?php body_class($body_class); ?>>
    <div class="main-container">
    <section class="c-sections header_mazhabi">
        <div class="container">
            <div class="row ">
                <div class="col-md-12 col-sm-12 col-xs-12 icon_header_mazhabi">
                    <div class="site_main_logo">
                        <?php 
                        $title_tag = 'h1';
                        if(!(is_home()||is_front_page()))
                        {
                            $title_tag = 'span';
                        }

                         ?>
                        <<?=$title_tag?> class="site_main_name"><?php bloginfo('name'); ?></<?=$title_tag?>>
                        <span><?php bloginfo('description'); ?></span>
                    </div>
                    <div class="history">
                        <span class="online_store_socials">
                                <?php
                                $yahosein_socials = array(
                                    'facebook' => '',
                                    'instagram' => '',
                                    'google-pluse' => '',
                                    'telegram' => '',
                                    'whatsapp' => '',
                                    'android' => '',
                                    'windows' => '',
                                    );
                                global $yahosein;
                                foreach ($yahosein_socials as $class => $txt) {
                                    $s = '';
                                    if (isset($yahosein['opt-social-' . $class])) {
                                        $s = $yahosein['opt-social-' . $class];
                                    }

                                    if (!empty($s)) {
                                        if ($class == 'telegram') {
                                            $class = 'send';
                                        }

                                        echo '<a title="شبکه ی اجتماعی ' . $class . '" href="' . $s . '" class="  btn-social-icon btn-' . $class . '"><i class="fa fa-' . $class . '"></i></a>';
                                    }
                                }
                                if(isset($yahosein['opt-social-feed']) && $yahosein['opt-social-feed'] ==1){
                                ?><a title="فید سایت" href="<?php echo get_feed_link(); ?>" class="  btn-social-icon btn-rss"><i class="fa fa-rss"></i></a><?php }
                                if (!is_user_logged_in()) {
                                    if($yahosein['opt-social-reg']==1){
                                    ?><a title="عضویت در سایت" href="<?php echo wp_registration_url(); ?>" class="  btn-social-icon "><i class="fa fa-user-plus"></i></a><?php } if($yahosein['opt-social-login']==1){ ?><a title="ورود به سایت" href="<?php echo wp_login_url(home_url()); ?>" class=" btn-social-icon "><i class="fa fa-user"></i></a><?php }

                                }

                                ?>
                    </span>
                        <span class="Tarikh_Time_header hidden-sm hidden-xs">
                            <div class="header_tarikh"><span class="m_date"><i class="fa fa-clock-o"></i><?php echo date_i18n( 'H:i', current_time('timestamp'));?></span></div>
                    <div class="header_time"><span class="m_calendar"><i class="fa fa-calendar"></i> <?php echo date_i18n( 'l d F Y', current_time('timestamp')); ?> </span></div>
                    </span>
                </div>
            </div>
        </div>
        </div>
    </section>
    <section class="c-sections mazhabi_main_menu_navbar">
        <div class="container">
            <div class="row ">
                <div class="col-md-12 col-sm-12 col-xs-12">
                    <div class="meno_index_top meno_pic">
                        <nav class="navbar meno_navar_bala ">
                            <div class="navbar-header">
                                 <a class="navbar-brand" href="<?php bloginfo( 'url' ); ?>"><?php bloginfo( 'name' ); ?></a>
                                <button type="button" class="navbar-toggle" data-toggle="collapse" data-target="#myNavbar">
                                    <span class="icon-bar"></span>
                                    <span class="icon-bar"></span>
                                    <span class="icon-bar"></span>
                                </button>
                            </div>
                            
                            <div class="collapse navbar-collapse" id="myNavbar">
                               
                                <ul class="nav navbar-nav" id="top-menu">
                                <?php
                                if(has_nav_menu('menu-main'))
                                {
                                    $args = array(
                                        'container' => false,
                                        'theme_location' => 'menu-main',
                                        'items_wrap' => '%3$s'
                                    );
                                    if(class_exists('wp_bootstrap_navwalker')){
                                        $args['walker']= new wp_bootstrap_navwalker();
                                        $args['caret_class']= 'fa  fa-angle-down';
                                    }
                                    wp_nav_menu($args);
                                }else
                                {
                                    echo '<li><a href="'.admin_url('nav-menus.php' ).'">برای این قسمت منویی تعریف نشده،برای تعریف منو کلیک کنید</a></li>';
                                }
                                ?>
                                </ul>
                                <ul class="nav navbar-nav navbar-left">
                                    <form id="custom-search-input" action="<?php bloginfo( 'url' ); ?>">
                                        <div class="input-group">
                                            <input title="برای جستجو تایپ کنید" class="form-control " placeholder="برای جستجو تایپ کنید" name="s" type="text">
                                            <span class="input-group-btn">
                                            <button class="btn btn-info " type="submit" value="">
                                             <i class="fa fa-search"></i>
                                            </button>
                                        </span>
                                        </div>
                                    </form>
                                </ul>
                            </div>
                            
                        </nav>
                    </div>
                </div>
            </div>
        </div>
    </section>


    <?php
    /**
     * هماهنگی با پلاگین
     * https://wordpress.org/plugins/breadcrumb-navxt/
     */
    
    if(function_exists('bcn_display') && !is_home() && !is_page_template() && !is_single() && !is_singular())
    {
    ?>

    <section class="c-sections menus-breadcrumbs">
         <div class="container">
             <div class="row-fluid">
             <div class="col-md-12 breadcrumb">
                <?php bcn_display(); ?>
             </div>
             </div>
             </div>
    </section>
    <?php
    }
    ?>


