<?php
/**
 * The template for displaying comments
 *
 * This is the template that displays the area of the page that contains both the current comments
 * and the comment form.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package yahosein
 */

/*
 * If the current post is protected by a password and
 * the visitor has not yet entered the password we will
 * return early without loading the comments.
 */
if ( post_password_required() ) {
	return;
}
?>

<div id="comments" class="comments-area widget_bkground_content_bg shadow_contects">

	<?php
	// You can start editing here -- including this comment!
	if ( have_comments() ) : ?>
		<h2 class="comments-title">
			<?php
				printf( // WPCS: XSS OK.
					esc_html( _nx( 'یک نظر در &ldquo;%2$s&rdquo;', '%1$s نظر در &ldquo;%2$s&rdquo;', get_comments_number(), 'comments title', 'yahosein' ) ),
					number_format_i18n( get_comments_number() ),
					'<span>' . get_the_title() . '</span>'
				);
			?>
		</h2><!-- .comments-title -->

		<?php if ( get_comment_pages_count() > 1 && get_option( 'page_comments' ) ) : // Are there comments to navigate through? ?>
		<nav id="comment-nav-above" class="navigation comment-navigation" role="navigation">
			<h2 class="screen-reader-text"><?php esc_html_e( 'Comment navigation', 'yahosein' ); ?></h2>
			<div class="nav-links">

				<div class="nav-previous"><?php previous_comments_link( esc_html__( 'نظرات قبلی', 'yahosein' ) ); ?></div>
				<div class="nav-next"><?php next_comments_link( esc_html__( 'نظرات بعدی', 'yahosein' ) ); ?></div>

			</div><!-- .nav-links -->
		</nav><!-- #comment-nav-above -->
		<?php endif; // Check for comment navigation. ?>

		<ol class="comment-list">
			<?php
				wp_list_comments( array(
					'style'      => 'ol',
					'short_ping' => true,
					'avatar_size' => 64,
					'callback' => 'yahosein_commentc_format',
				) );
			?>
		</ol><!-- .comment-list -->

		<?php if ( get_comment_pages_count() > 1 && get_option( 'page_comments' ) ) : // Are there comments to navigate through? ?>
		<nav id="comment-nav-below" class="navigation comment-navigation" role="navigation">
			<h2 class="screen-reader-text"><?php esc_html_e( 'Comment navigation', 'yahosein' ); ?></h2>
			<div class="nav-links">

				<div class="nav-previous"><?php previous_comments_link( esc_html__( 'Older Comments', 'yahosein' ) ); ?></div>
				<div class="nav-next"><?php next_comments_link( esc_html__( 'Newer Comments', 'yahosein' ) ); ?></div>

			</div><!-- .nav-links -->
		</nav><!-- #comment-nav-below -->
		<?php
		endif; // Check for comment navigation.

	endif; // Check for have_comments().


	// If comments are closed and there are comments, let's leave a little note, shall we?
	if ( ! comments_open() && get_comments_number() && post_type_supports( get_post_type(), 'comments' ) ) : ?>

		<p class="no-comments"><?php esc_html_e( 'Comments are closed.', 'yahosein' ); ?></p>
	<?php
	endif;

	comment_form(array('class_submit' => 'btn btn-default pull-right'));
	?>
	<div class="clearfix"></div>
</div><!-- #comments -->

<?php
function yahosein_commentc_format($comment, $args, $depth)
{
	?>
		<li id="comment-<?php comment_ID() ?>" <?php comment_class(); ?>>
        <article id="div-comment-<?php comment_ID() ?>" class="comment-body">
            <footer class="comment-meta">
                <div class="comment-author vcard">
                    <?php 
				            if ( $args['avatar_size'] != 0 ) {
				                echo get_avatar( $comment, $args['avatar_size'] ); 
				            } 
                     ?>

                    <b class="fn"><?php echo get_comment_author_link(); ?></b> <span class="says">گفت:</span>
                    <!-- .comment-author -->
                    <span class="comment-metadata">
					            <a href="<?php echo htmlspecialchars( get_comment_link( $comment->comment_ID ) ); ?>"><?php
					                /* translators: 1: date, 2: time */
					                printf( 
					                    __('%1$s at %2$s'), 
					                    get_comment_date(),  
					                    get_comment_time() 
					                ); ?>
					            </a><?php 
					            edit_comment_link( __( '(Edit)' ), '  ', '' ); ?>
                    </span>
                    <div class="reply">
											<?php comment_reply_link(array_merge( $args, array('depth' => $depth, 'max_depth' => $args['max_depth']))) ?>
                    </div>
                </div>
                <!-- .comment-metadata -->

								<?php if ($comment->comment_approved == '0') : ?>
                <p class="comment-awaiting-moderation"><i class="fa fa-cog fa-spin fa-3x fa-fw"></i>
                    <span class="sr-only">Loading...</span>دیدگاه شما در انتظار بررسی است.</p>
								<?php endif; ?>

            </footer>
            <!-- .comment-meta -->
            <div class="comment-content">
                <p>
                	<?php comment_text(); ?>
                </p>
            </div>
            <!-- .comment-content -->
        </article>
        <!-- .comment-body -->
    <!-- </li> -->

	<?php
}
