<?php
defined('ABSPATH') or die('No script kiddies please!');

add_action( 'widgets_init', 'roman_reg_double_ad' );
function roman_reg_double_ad() {

	register_widget( 'yahosein_widget_double_ad' );

}

class yahosein_widget_double_ad extends WP_Widget {
	private static $widget_id;

	/*  Constructor
	/* ------------------------------------ */
	function __construct() {
		parent::__construct(false, __('A_wd7:: تبلیغ دوتایی', 'yahosein'), array('description' => __(':: wd7::نمایش تبلیغ دوتایی', 'yahosein'), 'classname' => 'yahosein_widget_double_ad news-min-1 widget'));
	}

	/**
	 * Front-end display of widget.
	 *
	 * @see WP_Widget::widget()
	 *
	 * @param array $args Widget arguments.
	 * @param array $instance Saved values from database.
	 */
	public function widget($args, $instance) {
		self::$widget_id = $args['widget_id'];
		echo $args['before_widget'];
		echo $args['before_title'] . apply_filters('widget_title', $instance['title']) . $args['after_title'] ;

		$this->tabsContent($instance);
		echo $args['after_widget'];
	}

	public function tabsContent($args) {

		$title = $args['title'];
		$img = $args['img'];
		$link = $args['link'];

		$title2 = $args['title2'];
		$img2 = $args['img2'];
		$link2 = $args['link2'];
		?>
		<div class="row">
			<div class="col-md-6 col-sm-6 col-xs-12">
				<a target="_blank" href="<?php echo $link ; ?>" rel="nofollow"><img class="tabligh-bottom" src="<?php echo $img; ?>" alt="<?php echo esc_attr($title ); ?>"></a>
			</div>
			<div class="col-md-6 col-sm-6 col-xs-12">
				<a target="_blank" href="<?php echo $link2 ; ?>" rel="nofollow"><img class="tabligh-bottom" src="<?php echo $img2; ?>" alt="<?php echo esc_attr($title2 ); ?>"></a>
			</div>

		</div>

		<?php

	}

	/**
	 * Back-end widget form.
	 *
	 * @see WP_Widget::form()
	 *
	 * @param array $instance Previously saved values from database.
	 */
	public function form($instance) {
		$title = !empty($instance['title']) ? $instance['title'] : __('تبلیغات', 'yahosein');
		$img = !empty($instance['img']) ? $instance['img'] : get_template_directory_uri().'/layouts/img/tablighat1.png';
		$link = !empty($instance['link']) ? $instance['link'] : get_bloginfo('url' );

		$title2 = !empty($instance['title2']) ? $instance['title2'] : __('تبلیغات', 'yahosein');
		$img2 = !empty($instance['img2']) ? $instance['img2'] : get_template_directory_uri().'/layouts/img/tablighat1.png';
		$link2 = !empty($instance['link2']) ? $instance['link2'] : get_bloginfo('url' );
		?>
		<style>
			.yahosein-cat-slider{ padding:3px; border:1px solid #bbb; border-radius:3px; margin:5px; }
			.yahosein-cat-slider select {  max-width: 100%; }
		</style>
		<p>
			<label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('عنوان:');?></label>
			<input class="widefat" id="<?php echo $this->get_field_id('title'); ?>"
			name="<?php echo $this->get_field_name('title'); ?>" type="text"
			value="<?php echo esc_attr($title); ?>">
		</p>
		<p>
			<label for="<?php echo $this->get_field_id('img'); ?>"><?php _e('مسیر عکس:');?></label>
			<input class="widefat" id="<?php echo $this->get_field_id('img'); ?>"
			name="<?php echo $this->get_field_name('img'); ?>" type="text"
			value="<?php echo esc_attr($img); ?>">
		</p>
		<p>
			<label for="<?php echo $this->get_field_id('link'); ?>"><?php _e('لینک:');?></label>
			<input class="widefat" id="<?php echo $this->get_field_id('link'); ?>"
			name="<?php echo $this->get_field_name('link'); ?>" type="text"
			value="<?php echo esc_attr($link); ?>">
		</p>
		<h2>تبلیغ دوم</h2>
		<p>
			<label for="<?php echo $this->get_field_id('title2'); ?>"><?php _e('عنوان:');?></label>
			<input class="widefat" id="<?php echo $this->get_field_id('title2'); ?>"
			name="<?php echo $this->get_field_name('title2'); ?>" type="text"
			value="<?php echo esc_attr($title2); ?>">
		</p>
		<p>
			<label for="<?php echo $this->get_field_id('img2'); ?>"><?php _e('مسیر عکس:');?></label>
			<input class="widefat" id="<?php echo $this->get_field_id('img2'); ?>"
			name="<?php echo $this->get_field_name('img2'); ?>" type="text"
			value="<?php echo esc_attr($img2); ?>">
		</p>
		<p>
			<label for="<?php echo $this->get_field_id('link2'); ?>"><?php _e('لینک:');?></label>
			<input class="widefat" id="<?php echo $this->get_field_id('link2'); ?>"
			name="<?php echo $this->get_field_name('link2'); ?>" type="text"
			value="<?php echo esc_attr($link2); ?>">
		</p>

		<?php

	}

	/**
	 * Sanitize widget form values as they are saved.
	 *
	 * @see WP_Widget::update()
	 *
	 * @param array $new_instance Values just sent to be saved.
	 * @param array $old_instance Previously saved values from database.
	 *
	 * @return array Updated safe values to be saved.
	 */
	public function update($new_instance, $old_instance) {
		$instance = array();
		$instance['title'] = (!empty($new_instance['title'])) ? strip_tags($new_instance['title']) : 'تبلیغات';
		$instance['img'] = (!empty($new_instance['img'])) ? strip_tags($new_instance['img']) : get_template_directory_uri().'/layouts/img/tablighat1.png';
		$instance['link'] = (!empty($new_instance['link'])) ? strip_tags($new_instance['link']) : get_bloginfo('url' );

		$instance['title2'] = (!empty($new_instance['title2'])) ? strip_tags($new_instance['title2']) : 'تبلیغات';
		$instance['img2'] = (!empty($new_instance['img2'])) ? strip_tags($new_instance['img2']) : get_template_directory_uri().'/layouts/img/tablighat1.png';
		$instance['link2'] = (!empty($new_instance['link2'])) ? strip_tags($new_instance['link2']) : get_bloginfo('url' );

		return $instance;
	}


}
