<?php
defined('ABSPATH') or die('No script kiddies please!');

class yahosein_needed_plugins_module {
	public static $_instance = null;
	public $caps = array();

	public function __construct() {
		$this->includes();
		add_action('tgmpa_register', array($this, 'register_required_plugins'));
	}

	public static function _instance() {
		if (is_null(self::$_instance)) {
			self::$_instance = new self();
		}
		return self::$_instance;
	}

	public function includes() {
		$inc = array();
		$inc[] = dirname(__FILE__) . DIRECTORY_SEPARATOR . 'tmg' . DIRECTORY_SEPARATOR . 'class-tgm-plugin-activation.php';
		foreach ($inc as $in) {
			require_once $in;
		}
	}

	public function register_required_plugins() {
		/*
			 * Array of plugin arrays. Required keys are name and slug.
			 * If the source is NOT from the .org repo, then source is also required.
		*/
		$plugins = apply_filters('yahosein_required_plugins' ,array(

			// This is an example of how to include a plugin bundled with a theme.
			array(
				'name' => 'سئوی وردپرس', // The plugin name.
				'slug' => 'wordpress-seo', // The plugin slug (typically the folder name).
				'required' => false, // If false, the plugin is only 'recommended' instead of required.
				'force_activation' => false, // If true, plugin is activated upon theme activation and cannot be deactivated until theme switch.
				'force_deactivation' => false, // If true, plugin is deactivated upon theme switch, useful for theme-specific plugins.
			),
			array(
			'name' => 'Breadcrumb NavXT',
			'slug' => 'breadcrumb-navxt',
			'required' => false,
			'force_activation' => '',
			'force_deactivation' => ''
		),
			array(
				'name' => 'صفحه بندی', // The plugin name.
				'slug' => 'wp-pagenavi/', // The plugin slug (typically the folder name).
				'required' => false, // If false, the plugin is only 'recommended' instead of required.
				'force_activation' => false, // If true, plugin is activated upon theme activation and cannot be deactivated until theme switch.
				'force_deactivation' => false, // If true, plugin is deactivated upon theme switch, useful for theme-specific plugins.
			),
			array(
				'name' => 'امتیاز دهی ستاره ای', // The plugin name.
				'slug' => 'wp-postratings', // The plugin slug (typically the folder name).
				'required' => false, // If false, the plugin is only 'recommended' instead of required.
				'force_activation' => false, // If true, plugin is activated upon theme activation and cannot be deactivated until theme switch.
				'force_deactivation' => false, // If true, plugin is deactivated upon theme switch, useful for theme-specific plugins.
			),
			array(
				'name' => 'پارسی سخن', // The plugin name.
				'slug' => 'parsi-sokhan', // The plugin slug (typically the folder name).
				'required' => 1, // If false, the plugin is only 'recommended' instead of required.
				'force_activation' => false, // If true, plugin is activated upon theme activation and cannot be deactivated until theme switch.
				'force_deactivation' => false, // If true, plugin is deactivated upon theme switch, useful for theme-specific plugins.
			),
			array(
				'name' => 'اوقات شرعی', // The plugin name.
				'slug' => 'azan', // The plugin slug (typically the folder name).
				'required' => 1, // If false, the plugin is only 'recommended' instead of required.
				'force_activation' => false, // If true, plugin is activated upon theme activation and cannot be deactivated until theme switch.
				'force_deactivation' => false, // If true, plugin is deactivated upon theme switch, useful for theme-specific plugins.
			),


		));
		
		/*
			 * Array of configuration settings. Amend each line as needed.
			 *
			 * TGMPA will start providing localized text strings soon. If you already have translations of our standard
			 * strings available, please help us make TGMPA even better by giving us access to these translations or by
			 * sending in a pull-request with .po file(s) with the translations.
			 *
			 * Only uncomment the strings in the config array if you want to customize the strings.
		*/
		$config = array(
			'id' => 'yahosein', // Unique ID for hashing notices for multiple instances of TGMPA.
			'default_path' => '', // Default absolute path to bundled plugins.
			'menu' => 'yahosein-install-plugins', // Menu slug.
			'parent_slug' => 'themes.php', // Parent menu slug.
			'capability' => 'edit_theme_options', // Capability needed to view plugin install page, should be a capability associated with the parent menu used.
			'has_notices' => true, // Show admin notices or not.
			'dismissable' => true, // If false, a user cannot dismiss the nag message.
			'dismiss_msg' => '', // If 'dismissable' is false, this message will be output at top of nag.
			'is_automatic' => false, // Automatically activate plugins after installation or not.
			'message' => '', // Message to output right before the plugins table.


		);

		tgmpa($plugins, $config);
	}

}
yahosein_needed_plugins_module::_instance();
