<?php
/**
 * Plugin Name: Gravity Forms Updater /  بروزرسان خودکار گراویتی فرمز
 * Description: به روز کننده پلاگین گراویتی فرمز از روی مخزن گیت هاب
 * Plugin URI: http://shahab-net.ir/?p=297
 * Author: shahab-net.ir
 * Author URI: http://shahab-net.ir
 * Version: 1.1
 */

if (!defined('ABSPATH')) {
	exit;
}

add_action('plugins_loaded', array('__ppu', 'get_instance'));

class __ppu {

	private static $instance = null;
	public $new_ver = '';

	public static function get_instance() {
		if (!isset(self::$instance)) {
			self::$instance = new self;
		}

		return self::$instance;
	}

	private function __construct() {

		if (!class_exists('GFForms')) {
			return;
		}

		$version_info = GFCommon::get_version_info(true);
		$this->new_ver = $version_info['version'];

		$this->plugins_loaded();

	}

	function plugins_loaded() {
		add_filter('transient_update_plugins', array($this, 'check_update'), 9);
		add_filter('site_transient_update_plugins', array($this, 'check_update'), 9);
	}

	function check_update($option) {
		$new_ver = $this->new_ver;

		//get old version data
		$slug = 'gravityforms-master/gravityforms.php';
		$file = ABSPATH . DIRECTORY_SEPARATOR . 'wp-content' . DIRECTORY_SEPARATOR . 'plugins' . DIRECTORY_SEPARATOR . $slug;
		$old_ver = '';
		$plugin_meta = (get_plugin_data($file));
		$old_ver = $plugin_meta['Version'];

		//check update exists
		if (version_compare($new_ver, $old_ver) > 0) {
			@$option->response['gravityforms-master/gravityforms.php']->plugin = 'gravityforms-master/gravityforms.php';
			$option->response['gravityforms-master/gravityforms.php']->slug = 'gravityforms';
			$option->response['gravityforms-master/gravityforms.php']->package = 'https://github.com/wp-premium/gravityforms/archive/master.zip';
			$option->response['gravityforms-master/gravityforms.php']->new_version = $new_ver;
			$option->response['gravityforms-master/gravityforms.php']->id = '0';
		}

		return $option;
	}

}
